<?php
require_once('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Session expired. Please login again.']);
    exit;
}

$user_id = $_SESSION['user_id'];
$old_password = $_POST['old_password'] ?? '';
$new_password = $_POST['new_password'] ?? '';

if (!$old_password || !$new_password) {
    echo json_encode(['status' => 'error', 'message' => 'Both old and new passwords are required.']);
    exit;
}

// Encode passwords
$old_password_encoded = base64_encode($old_password);
$new_password_encoded = base64_encode($new_password);

try {
    // Check if old password is correct
    $stmt = $pdo->prepare("SELECT 1 FROM user_master WHERE user_id = :user_id AND password = :password");
    $stmt->execute([
        ':user_id' => $user_id,
        ':password' => $old_password_encoded
    ]);

    if (!$stmt->fetchColumn()) {
        echo json_encode(['status' => 'error', 'message' => 'Old password is incorrect.']);
        exit;
    }

    // Check if new password is same as old
    if ($old_password_encoded === $new_password_encoded) {
        echo json_encode(['status' => 'error', 'message' => 'New password cannot be the same as old password.']);
        exit;
    }

    // Begin transaction
    $pdo->beginTransaction();

    // Update user_master
    $stmt1 = $pdo->prepare("UPDATE user_master SET password = :new_password WHERE user_id = :user_id");
    $stmt1->execute([
        ':new_password' => $new_password_encoded,
        ':user_id' => $user_id
    ]);

    // Update student_master
    $stmt2 = $pdo->prepare("UPDATE student_master SET password = :new_password WHERE user_id = :user_id");
    $stmt2->execute([
        ':new_password' => $new_password_encoded,
        ':user_id' => $user_id
    ]);

    $pdo->commit();

    echo json_encode(['status' => 'success', 'message' => 'Password updated successfully.']);
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['status' => 'error', 'message' => 'Failed to update password.']);
}