<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $institute_id = $_SESSION['institute_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;

    if (!$institute_id || !$user_id) {
        echo json_encode(["status" => "error", "message" => "Missing institute_id or user_id in session."]);
        exit;
    }

    // Get only distinct courses with best attempt >= 70%
    $sql = "SELECT 
                c.course_id,
                c.course_title,
                c.start_date,
                c.end_date,
                aa.best_obtained_marks AS obtained_marks,
                aa.total_marks,
                (aa.best_obtained_marks / aa.total_marks * 100) AS percentage,
                aa.created_date AS completed_date
            FROM (
                SELECT 
                    a.course_id,
                    a.institute_id,
                    a.user_id,
                    MAX(a.obtained_marks) AS best_obtained_marks,
                    MAX(a.total_marks) AS total_marks,
                    MAX(a.created_date) AS created_date
                FROM assignment_attempts a
                WHERE a.user_id = :user_id
                  AND a.institute_id = :institute_id
                GROUP BY a.course_id, a.institute_id, a.user_id
                HAVING (MAX(a.obtained_marks) / MAX(a.total_marks) * 100) >= 70
            ) aa
            LEFT JOIN course_master c 
                ON aa.course_id = c.course_id";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user_id' => $user_id,
        ':institute_id' => $institute_id
    ]);

    $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => "success",
        "courses" => $courses
    ]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>
