<?php
session_start();
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {

    $institute_id = $_SESSION['institute_id'] ?? null;

    if (empty($institute_id)) {
        echo json_encode([
            "status" => "error",
            "message" => "Institute ID not found in session."
        ]);
        exit;
    }


    // Fetch courses
	$sqlCourses = "
	    SELECT 
	        c.course_id AS id,
	        c.course_title AS name
	    FROM course_master c
	    JOIN institute_courses ic 
	        ON ic.course_id = c.course_id
	    WHERE c.is_block != 1 AND is_publish = 1
	      AND ic.institute_id = :institute_id
	      AND c.course_category IS NOT NULL
	      AND c.course_category != 0
	      AND c.course_category != ''
	";


    $stmtCourses = $pdo->prepare($sqlCourses);
    $stmtCourses->execute([
        ':institute_id' => $institute_id
    ]);

    $courses = $stmtCourses->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => "success",
        "courses" => $courses
    ]);
    exit;

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
    exit;
}