<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $institute_id = $_SESSION['institute_id'] ?? null;

    if (!$institute_id) {
        echo json_encode(["status" => "error", "message" => "Institute ID not found in session."]);
        exit;
    }

    // Get folder name for current institute
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }

    // Get folder name for superadmin (institute_id = 1)
    $stmtSuperFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = 1");
    $stmtSuperFolder->execute();
    $superadminFolder = $stmtSuperFolder->fetchColumn();

    // Only get courses assigned to this institute (via institute_courses)
    $sqlCourses = "SELECT 
                    c.course_id,
                    c.course_title,
                    c.course_img,
                    c.hours,
                    c.course_category,
                    c.is_superadmin_course,
                    cat.category_name
                FROM course_master c
                JOIN category_master cat ON c.course_category = cat.category_id
                JOIN institute_courses ic ON ic.course_id = c.course_id
                WHERE ic.institute_id = :institute_id AND c.is_block = 0 AND c.is_publish = 1";

    $stmtCourses = $pdo->prepare($sqlCourses);
    $stmtCourses->execute([':institute_id' => $institute_id]);
    $courses = $stmtCourses->fetchAll(PDO::FETCH_ASSOC);

    // Add full image path based on whether course is superadmin or not
    foreach ($courses as &$course) {
        $imageName = $course['course_img'];
        if (!empty($imageName)) {
            $folderToUse = ($course['is_superadmin_course'] ?? 0) == 1 ? $superadminFolder : $currentFolder;
            $course['course_img'] = "./Z1mn7_adm/institutes/{$folderToUse}/course_images/{$imageName}";
        }
    }

    // Fetch distinct categories from assigned courses only
    $sqlCategories = "SELECT DISTINCT 
                        cat.category_id, 
                        cat.category_name 
                    FROM course_master c
                    JOIN category_master cat ON c.course_category = cat.category_id
                    JOIN institute_courses ic ON ic.course_id = c.course_id
                    WHERE ic.institute_id = :institute_id";

    $stmtCategories = $pdo->prepare($sqlCategories);
    $stmtCategories->execute([':institute_id' => $institute_id]);
    $categories = $stmtCategories->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => "success",
        "courses" => $courses,
        "categories" => $categories
    ]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>