<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $institute_id = $_SESSION['institute_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;

    if (!$institute_id || !$user_id) {
        echo json_encode(["status" => "error", "message" => "Missing institute_id or user_id in session."]);
        exit;
    }

    // Get only active courses that are not yet attempted by this user
    $sqlCourses = "SELECT 
                        c.course_id,
                        c.course_title,
                        c.start_date,
                        c.end_date,
                        c.hours,
                        c.course_category,
                        c.is_superadmin_course,
                        cat.category_name
                    FROM course_master c
                    JOIN category_master cat 
                        ON c.course_category = cat.category_id
                    JOIN institute_courses ic 
                        ON ic.course_id = c.course_id
                    WHERE ic.institute_id = :institute_id_outer
                      AND c.end_date >= CURDATE()
                      AND NOT EXISTS (
                            SELECT 1 
                            FROM assignment_attempts aa
                            WHERE aa.course_id = c.course_id
                              AND aa.user_id = :user_id
                              AND aa.institute_id = :institute_id_inner
                        ) AND c.is_block = 0 AND c.is_publish = 1";

    $stmtCourses = $pdo->prepare($sqlCourses);
    $stmtCourses->execute([
        ':institute_id_outer' => $institute_id,
        ':institute_id_inner' => $institute_id,
        ':user_id' => $user_id
    ]);

    $courses = $stmtCourses->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => "success",
        "courses" => $courses
    ]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>