<?php
// Get the PDF url from the query string (base64 encoded or plain URL)
$pdfUrl = isset($_GET['src']) ? $_GET['src'] : '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>PDF Viewer</title>
<style>
  body, html {
    margin: 0; padding: 0; height: 100%; overflow: hidden; background: #fff;
  }
  #pdfContainer {
    position: relative;
    height: calc(100vh - 80px);
    overflow-y: auto;
  }
  iframe {
    width: 100%;
    height: 100%;
    border: none;
    display: block;
  }
  button {
    height: 40px;
    width: 100px;
    margin: 5px;
    background-color: #5C2C8B;
    color: white;
    border: none;
    cursor: pointer;
    border-radius: 6px;
  }
</style>
</head>
<body>
  <div style="text-align:center; padding: 10px;">
    <button id="scrollUp">Scroll Up</button>
    <button id="scrollDown">Scroll Down</button>
  </div>
  <div id="pdfContainer">
    <iframe src="<?php echo htmlspecialchars($pdfUrl); ?>#toolbar=0&navpanes=0&scrollbar=0" oncontextmenu="return false;"></iframe>
  </div>

  <script>
    const container = document.getElementById('pdfContainer');
    document.getElementById('scrollUp').onclick = () => {
      container.scrollBy({ top: -100, behavior: 'smooth' });
    };
    document.getElementById('scrollDown').onclick = () => {
      container.scrollBy({ top: 100, behavior: 'smooth' });
    };

    // Disable right-click on container
    container.addEventListener('contextmenu', e => e.preventDefault());
  </script>
</body>
</html>
