<?php
session_start();
header('Content-Type: application/json');

require_once('../includes/connection.php');
require_once('../includes/PHPMailerAutoload.php');
require_once('../includes/class.phpmailer.php');
require_once('../includes/class.smtp.php');

if (!isset($_SESSION['email_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Session expired. Please log in again.'
    ]);
    exit();
}

$institute_id   = $_SESSION['institute_id'] ?? '';
$institute_name = '';

if ($institute_id) {
$stmt = $pdo->prepare("SELECT institute_name FROM institute_master WHERE institute_id = ?");
$stmt->execute([$institute_id]);
$institute_name = $stmt->fetchColumn();
}


$mail = new PHPMailer(true);

try {

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception("Invalid request method");
    }

    $studentName = $_SESSION['user_name'] ?? 'Student';
    $email       = $_SESSION['email_id'] ?? '';
    $course_id   = $_POST['course'] ?? ''; 
    $course_name = $_POST['course_name'] ?? '';
    $category    = $_POST['category'] ?? '';
    $title       = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';

    if (!$email || !$title || !$description) {
        throw new Exception("Required fields missing");
    }

    // SMTP Configuration
    $mail->isSMTP();
    $mail->Host       = 'smtp.zoho.in';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'notifications@epicbiospheres.com';
    $mail->Password   = '8FLKDuJhzxZ1';
    $mail->SMTPSecure = 'tls';
    $mail->Port       = 587;

    $mail->setFrom('notifications@epicbiospheres.com', 'EPIC LMS');


    $recipientEmails = [];

    if ($category === 'Technical Issues') {

        $recipientEmails[] = 'techsupport@epicbiospehres.com';


    } elseif (
        $category === 'Certificate or Login-Related Issues' || $category === 'Course or Content-Related Queries'
    ) {

        $recipientEmails[] = 'meera.babre@epichim.com';

    } 
    /* elseif ($category === 'Course or Content-Related Queries' && $course_id) {

	$sql = "
	    SELECT mm.email_id FROM course_master cm
	    LEFT JOIN user_master mm 
	    ON FIND_IN_SET(mm.user_id, cm.mentor_ids)
	    WHERE mm.is_block !=1 AND cm.course_id = ?";
	
	$stmt = $pdo->prepare($sql);
	$stmt->execute([$course_id]);
	
	$mentors = $stmt->fetchAll(PDO::FETCH_ASSOC);
	
	foreach ($mentors as $row) {
	    if (!empty($row['email_id'])) {
	        $recipientEmails[] = $row['email_id'];
	    }
	}
    } */

    // Fallback email if nothing matched
    if (empty($recipientEmails)) {
        $recipientEmails[] = 'yusuf@kalpakolutions.com';
    }

    // Add recipients
    foreach (array_unique($recipientEmails) as $recipient) {
        $mail->addAddress($recipient);
    }


    if (
        isset($_FILES['attachment']) &&
        $_FILES['attachment']['error'] === UPLOAD_ERR_OK
    ) {
        $tmpPath  = $_FILES['attachment']['tmp_name'];
        $fileName = basename($_FILES['attachment']['name']);

        if (!is_uploaded_file($tmpPath)) {
            throw new Exception("Invalid file upload");
        }

        $mail->addAttachment($tmpPath, $fileName);
    }


    $mail->isHTML(true);
    $mail->Subject = 'Student Enquiry Submitted';

    $mail->Body = "
        <h3>Student Enquiry Details</h3>
        <table border='1' cellpadding='8' cellspacing='0'>
            <tr><td><b>Institute</b></td><td>{$institute_name}</td></tr>
            <tr><td><b>Student Name</b></td><td>{$studentName}</td></tr>
            <tr><td><b>Email</b></td><td>{$email}</td></tr>
            <tr><td><b>Course Program</b></td><td>{$course_name}</td></tr>
            <tr><td><b>Category</b></td><td>{$category}</td></tr>
            <tr><td><b>Issue Title</b></td><td>{$title}</td></tr>
            <tr><td><b>Description</b></td><td>{$description}</td></tr>
        </table>
        <br>
        <p>Regards,<br><b>EPIC LMS</b></p>
    ";

    $mail->send();

    echo json_encode([
        'status' => 'success',
        'message' => 'Your enquiry has been submitted successfully.'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}