<?php
session_start();
require_once('includes/connection.php');

require_once __DIR__ . '/vendor/pdf/dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;


if (!isset($_GET['course'])) {
    echo json_encode(['status' => 'error', 'message' => 'Missing course_id']);
    exit;
}
$course_id = intval($_GET['course']);

    $courseStmt = $pdo->prepare("
        SELECT course_title, created_date
        FROM course_master
        WHERE course_id = :id
    ");
    $courseStmt->bindParam(':id', $course_id);
    $courseStmt->execute();
    $course = $courseStmt->fetch(PDO::FETCH_ASSOC);

    if (!$course) {
        echo json_encode(['status' => 'error', 'message' => 'Course not found']);
        exit;
    }
    
    $course_title = $course['course_title'];
    
        // ✅ Fetch latest completion date from assignment_attempts where obtained >= 70%
        $attemptStmt = $pdo->prepare("
            SELECT created_date
            FROM assignment_attempts
            WHERE course_id = :course_id
              AND user_id = :user_id
              AND institute_id = :institute_id
              AND (obtained_marks / total_marks * 100) >= 70
            ORDER BY created_date DESC
            LIMIT 1
        ");
        $attemptStmt->execute([
            ':course_id' => $course_id,
            ':user_id' => $user_id,
            ':institute_id' => $institute_id
        ]);
        $attempt = $attemptStmt->fetch(PDO::FETCH_ASSOC);
        
        // If found, format the completion date, otherwise fallback
        if ($attempt && !empty($attempt['created_date'])) {
            $cert_date = date('d / M / Y', strtotime($attempt['created_date']));
        } else {
            $cert_date = date('d / M / Y'); // fallback
        }    

// Data

$user_name   = $_SESSION['user_name'] ?? "Student";

// If PDF is requested
if (isset($_GET['download']) && $_GET['download'] == 'pdf') {
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('isRemoteEnabled', true);
    $dompdf = new Dompdf($options);

    ob_start();
    ?>
    <div style="
        width: 100%;
        height: 90%;
        text-align: center;
        font-family: Arial, sans-serif;
        background: url('https://epicbiospheres.com/LMS/vendor/pdf/dompdf/certificate_background.png') no-repeat center center;
        background-size: cover;
        box-sizing: border-box;
    ">
    </br></br></br></br>    
          <img src="https://epicbiospheres.com/LMS/vendor/pdf/dompdf/certificate-watermark.png"
       style="    position: absolute;
    top: 15%;
    left: 50%;
    transform: translate(-50%, -50%);
    opacity: 0.2;
    height: 300px;
    z-index: 0;" />
        <h1 style="    font-weight: 700;
    margin: 0;
    color: #6A1B9A;
    font-size: 26px;
    margin-bottom: 10px;
    letter-spacing: 6px;">CERTIFICATE</h1>
        <div style="  font-size: 12px;
  color: #555;
  margin-bottom: 25px;">OF ACHIEVEMENT</div>
        <div style="  font-size: 12px;
  color: #555;
  margin-bottom: 40px;margin-top: 40px;">THIS CERTIFICATE IS PROUDLY PRESENTED TO</div>
        <div style="    font-size: 28px;
    font-weight: 700;
    color: #6A1B9A;
    letter-spacing: 6px;
    margin: 20px 0;
    text-transform: uppercase;"><?php echo $_SESSION['user_name']; ?></div>
        <div style="font-size:14px; margin:3px 0;color: #555;">FOR THE SUCCESSFUL COMPLETION OF:</div>
        <div style="font-size:16px; margin:50px 0;">
        <div style="font-size:12px;"><strong>COURSE:</strong> <?= htmlspecialchars($course_title) ?>&nbsp;&nbsp;&nbsp;
<strong>DATE:</strong> <?= htmlspecialchars($cert_date) ?></div>
        <div style="font-size:16px; color:#555; margin:30px 0;">
            We applaud your commitment to learning and congratulate you on your success!
        </div>
        <div style="margin-top:55px;"><img src="https://epicbiospheres.com/LMS/vendor/pdf/dompdf/logo.png" style="height: 60px;"></div>
    </div>
    </div>
    <?php
    $html = ob_get_clean();

    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();
    $filename = "Certificate_" . preg_replace('/\s+/', '_', $user_name) . ".pdf";
    $dompdf->stream($filename, ["Attachment" => true]);
    exit;
}
?>

<!-- Web View -->
    <div style="
        width: 100%;
        height: 90%;
        text-align: center;
        font-family: Arial, sans-serif;
        background: url('https://epicbiospheres.com/LMS/vendor/pdf/dompdf/certificate_background.png') no-repeat center center;
        background-size: cover;
        box-sizing: border-box;
    ">
    </br></br>   
          <img src="https://epicbiospheres.com/LMS/vendor/pdf/dompdf/certificate-watermark.png"
       style="    position: absolute;
    top: 15%;
    left: 50%;
    transform: translate(-50%, -50%);
    opacity: 0.2;
    height: 230px;
    z-index: 0;" />
        <h1 style="    font-weight: 700;
    margin: 0;
    color: #6A1B9A;
    font-size: 26px;
    margin-bottom: 10px;
    letter-spacing: 6px;">CERTIFICATE</h1>
        <div style="  font-size: 12px;
  color: #555;
  margin-bottom: 25px;">OF ACHIEVEMENT</div>
        <div style="  font-size: 12px;
  color: #555;
  margin-bottom: 20px;margin-top: 20px;">THIS CERTIFICATE IS PROUDLY PRESENTED TO</div>
        <div style="    font-size: 28px;
    font-weight: 700;
    color: #6A1B9A;
    letter-spacing: 6px;
    margin: 20px 0;
    text-transform: uppercase;"><?php echo $_SESSION['user_name']; ?></div>
        <div style="font-size:14px; margin:3px 0;color: #555;">FOR THE SUCCESSFUL COMPLETION OF:</div>
        <div style="font-size:16px; margin:50px 0;">
        <div style="font-size:12px;color: #222;
    font-weight: 600;"><strong style="color: #222;">COURSE:</strong> <?= htmlspecialchars($course_title) ?>&nbsp;&nbsp;&nbsp;
<strong style="color: #222;">DATE:</strong> <?= htmlspecialchars($cert_date) ?></div>
        <div style="font-size:16px; color:#555; margin:30px 0;">
            We applaud your commitment to learning and congratulate you on your success!
        </div>
        <div style="margin-top:40px;"><img src="https://epicbiospheres.com/LMS/vendor/pdf/dompdf/logo.png" style="margin-bottom:10px;height: 50px;"></div>
    </div>
    </div>

<div style="margin-top:20px; text-align:center;">
    <a href="certificate.php?course=<?= urlencode($_GET['course']) ?>&download=pdf" class="btn btn-primary">
        Download PDF
    </a>
</div>