<?php 
$page_name = 'Settings - Reset Password';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>
.content-wrapper, .main-footer {
    margin-left: unset !important;
}
.main-header .navbar {
    margin-left: unset !important;    
}
.skin-blue .main-header .navbar {
    border-bottom: 1px solid #5C2C8B;
}

.form-success {
    color: #065f46;
    font-weight: 500;
}

.form-error {
    color: #991b1b;
    font-weight: 500;
}

.content {
  padding: 20px 50px;
}
</style>

<section class="content">
    <form id="resetPasswordForm">
        <div class="box-body">
            <div class="col-md-12">

                <div class="form-group clearfix">
                    <label class="col-md-2 col-form-label"><b>Reset Password</b></label>
                </div>

                <div class="form-group clearfix">
                    <label class="col-md-2 col-form-label">Old Password</label>
                    <div class="col-md-4">
                        <input class="form-control" type="text" id="old_password" name="old_password" required>
                    </div>
                </div>

                <div class="form-group clearfix">
                    <label class="col-md-2 col-form-label">New Password</label>
                    <div class="col-md-4">
                        <input class="form-control" type="text" id="new_password" name="new_password" required>
                    </div>
                </div>

                <div class="form-group clearfix">
                    <label class="col-md-2 col-form-label">Confirm New Password</label>
                    <div class="col-md-4">
                        <input class="form-control" type="password" id="confirm_password" name="confirm_password" required>
                    </div>
                </div>

                <div class="box-footer mt-4" style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary" id="btnSubmit">Submit</button>
                </div>

                <div class="box-footer mt-2">
                    <div id="formMessage" style="display:none;"></div>
                </div>

            </div>
        </div>
    </form>
</section>

<?php require_once('includes/footer.php'); ?>

<script>
function showMessage(type, message) {
    const msgBox = $("#formMessage");
    msgBox.removeClass("form-success form-error")
          .addClass(type === "success" ? "form-success" : "form-error")
          .html(message)
          .fadeIn();

    setTimeout(() => { msgBox.fadeOut(); }, 5000);
}

$("#resetPasswordForm").on("submit", function(e) {
    e.preventDefault();

    const oldPassword = $("#old_password").val().trim();
    const newPassword = $("#new_password").val().trim();
    const confirmPassword = $("#confirm_password").val().trim();

    if (newPassword !== confirmPassword) {
        showMessage("error", "New Password and Confirm Password do not match.");
        return;
    }

    let btn = $("#btnSubmit");
    btn.prop("disabled", true).text("Updating...");

    $.ajax({
        url: "apis/change_password.php",
        type: "POST",
        data: {
            old_password: oldPassword,
            new_password: newPassword
        },
        dataType: "json",
        success: function(res) {
            if (res.status === "success") {
                showMessage("success", res.message);
                $("#resetPasswordForm")[0].reset();
            } else {
                showMessage("error", res.message);
            }
        },
        error: function() {
            showMessage("error", "Server error. Please try again later.");
        },
        complete: function() {
            btn.prop("disabled", false).text("Submit");
        }
    });
});
</script>