<?php 
$page_name = 'Course Details';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>
.content-wrapper, .main-footer {
    margin-left: unset !important;
}

.main-header .navbar {
    margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
    border-bottom: 1px solid #5C2C8B;
}

.course-card {
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 0 10px rgba(0,0,0,0.06);
  overflow: hidden;
  margin-bottom: 30px;
  transition: 0.3s;
  text-align: left;
  height: 100%;
  width: 75%;
  margin: 35px 0px;  
  box-shadow: 0 6px 16px rgba(59, 30, 132, 0.15);
}


.course-img {
  width: 100%;
  height: 150px;
  object-fit: cover;
  margin-bottom: 10px;
}

.course-meta {
    font-size: 10px;
    color: #5C2C8B;
    margin-bottom: 5px;
    text-transform: uppercase;
    background: #F2E9FD;
    padding: 5px;
    border-radius: 5px;
}

.course-title {
    font-size: 13px;
    font-weight: 600;
    color: #3b1e84;
    margin-bottom: 8px;
    padding: 10px 10px 0px 10px;
}

.course-duration {
    font-size: 14px;
    color: #666;
    padding: 0px 10px 10px 10px;
}

.course-hr
{
    margin-top: 15px;
    margin-bottom: 15px;
}

.tags-course
{
    padding: 5px 10px;
}

.course-box-user {
    width: 75%;
    margin: 35px 0px;
    box-shadow: 0 6px 16px rgba(59, 30, 132, 0.15);
    -webkit-box-shadow: unset;
    display: flex;
    align-items: center;    
    min-height: 100px;
    background: #fff;
    -webkit-box-shadow: 0 5px 20px rgba(0, 0, 0, .1);
    border-radius: 10px;
    padding: 15px;    
}

.content {
    padding: 20px 50px;
}
.category-title
{
        font-size: 16px;
    font-weight: 600;
    color: #3b1e84;
    margin-top: 0;
}


.content-wrapper, .main-footer {
    margin-left: unset !important;
}

.main-header .navbar {
    margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
    border-bottom: 1px solid #5C2C8B;
}

.info-box11 {
  border: 1px solid #E2D9F3;
  border-radius: 8px;
  padding: 20px;
  font-family: 'Segoe UI', sans-serif;
  font-size: 14px;
  color: #3A3A3A;
  background: #fff;
  max-width: 800px;
}

.section-title {
  font-weight: 700;
  font-size: 13px;
  text-transform: uppercase;
  margin-bottom: 5px;
}

.text-purple {
  color: #5C2C8B;
}

.fw-semibold {
  font-weight: 600;
}

.border-md-end {
  border-right: 1px solid #E2D9F3;
}

@media (max-width: 767px) {
  .border-md-end {
    border-right: none;
    border-bottom: 1px solid #E2D9F3;
    padding-bottom: 15px;
    margin-bottom: 15px;
  }
}

.course-info-container h2 {
  color: #5C2C8B;
  font-size: 28px;
  font-weight: 600;
  margin-bottom: 20px;
}

.info-box1 {
  border: 1px solid #eee;
  border-radius: 8px;
  padding: 20px 30px;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.info-box1 h4 {
  font-size: 16px;
  font-weight: 600;
  margin-bottom: 20px;
  color: #3c1e6e;
}

.info-grid {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 15px 40px;
}

.info-item {
  font-size: 14px;
  display: flex;
  align-items: flex-start;
  color: #5C2C8B;
  line-height: 1.5;
}

.faq-question {
  font-size: 14px;
  display: flex;
  align-items: flex-start;
  color: #5C2C8B;
  line-height: 1.5;
  cursor: pointer;
  padding-top: 13px;
}

.info-item::before {
  content: '▶';
  font-size: 10px;
  margin-right: 8px;
  color: #5C2C8B;
  margin-top: 5px;
}

@media (max-width: 768px) {
  .info-column {
    flex: 1 1 100%;
  }
}

.module-card {
  background-color: #f4f0fa;
  border-radius: 8px;
  padding: 25px;
  box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}

.course-title {
  font-size: 20px;
  font-weight: 700;
  margin-bottom: 5px;
}

.author {
  color: #666;
  font-size: 14px;
  margin-bottom: 25px;
}

.module {
  margin-bottom: 30px;
  border-bottom: 1px solid #ccc;
  padding-bottom: 15px;
}

.module:last-child {
  border-bottom: none;
}

.module-title {
  display: flex;
  align-items: center;
  font-weight: 600;
  margin-bottom: 8px;
}

.module-title i {
  margin-right: 8px;
  color: #5C2C8B;
  font-style: normal;
  font-size: 16px;
}

.module-desc {
  font-size: 14px;
  line-height: 1.6;
  color: #444;
}

@media (max-width: 600px) {
  h1 {
    font-size: 24px;
  }

  .course-title {
    font-size: 18px;
  }

  .module-title {
    font-size: 14px;
  }

  .module-desc {
    font-size: 13px;
  }
}

.skills-badge {
  background: #F2E9FD;
  padding: 5px;
  border-radius: 5px;
  color: #5C2C8B;
  font-size: 13px;
  margin: 10px 8px;
  display: inline-block;
}

.toggle-btn.active {
  background-color: #f4ebff !important;
  color: #5C2C8B !important;
  border: 1px solid transparent !important;
}

.toggle-btn.inactive {
  background-color: #fff !important;
  color: #FF3B30 !important;
  border: 1px solid #5C2C8B !important;
}

</style>


<section class="content">
    
<div class="row">
      <div class="col-md-4">
        <div id="imageContainer"></div>
        <button class="btn btn-primary w-100" id="startResumeBtn" style="width: 100%;margin-top: 10px;" onclick="location.href='course_materials.php?id=<?php echo $_GET['id']; ?>'"></button>
      </div>

      <div class="col-md-8">
        <h1 class="text-color" style="font-weight: 600;" id="course_title"></h1>
        <p class="box-title-mentor"><strong>Mentor:</strong></p>
        <p class="box-title-expert"><strong>Industry Expert:</strong></p>

        <div>
          <div class="info-box11">
            <div class="row no-gutters text-center text-md-start">
<div class="col-md-4 mb-3 mb-md-0 border-md-end pe-md-3">
  <div class="section-title text-danger">AT GLANCE</div>
  
  <!-- Dynamic Module Count -->
  <div class="fw-semibold text-purple" id="moduleCount"></div>
  
  <!-- Dynamic Video and Document Count -->
  <div id="mediaCount"><br></div>

  <div class="section-title text-danger mt-3">DETAILS TO KNOW</div>
  <div class="text-purple">Shareable certificate</div>
</div>

<div class="col-md-4 mb-3 mb-md-0 border-md-end px-md-3">
  <div class="fw-semibold text-purple" id="course-level"></div>
  <div id="level-description"></div>
  <div class="fw-semibold text-purple mt-3">Language</div>
  <div id="course-language"></div>
</div>



<div class="col-md-4 ps-md-3">
  <div class="fw-semibold text-purple">Flexible schedule</div>
  <div>Approx. <span id="course-hours"></span> hrs<br>Learn at your own pace</div>
</div>

            </div>
          </div>
        </div>
      </div>
    </div>
    

<div class="row mt-25 mb-3">
      <div class="col-md-12">
        <div class="d-flex gap-2">
          <button id="courseInfoBtn" class="btn fw-semibold px-4 py-2 toggle-btn active">
            Course Information
          </button>
          <button id="modulesBtn" class="btn fw-semibold px-4 py-2 toggle-btn inactive">
            Modules
          </button>
        </div>
      </div>
    </div>    



<div id="courseInfoSection">
      <div class="row">
        <div class="col-md-12">
          <h2 style="color:#5B2E8E;">Course Information</h2>
          
          <div id="course_description" style="    margin-bottom: 25px;">
          </div>      
          <div class="info-box1">
            <h4>What you'll learn</h4>
            <div class="info-grid">
            </div>
          </div>
        </div>
      </div>
      
      <br>

      <div class="row mt-3">
        <div class="col-md-12">
          <div class="info-box1">
            <h4>Skills You’ll Gain</h4>
            <div class="d-flex flex-wrap gap-2" id="skillsContainer">
            </div>
          </div>
        </div>
      </div>
      
      <br>

      <div class="row mt-3">
        <div class="col-md-12">
          <div class="info-box1">
            <h4>FAQs</h4>
		<div class="accordion" id="faqAccordion">
		</div>
          </div>
        </div>
      </div>
            
    </div>
    
    
    
 <div id="modulesSection" style="display: none;">
      <div class="row">
        <div class="col-md-12">
          <h2 style="color:#5B2E8E;">Modules</h2>
          <div class="module-card">

          </div>
        </div>
      </div>
    </div>
    


</section>
    


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {
  const courseId = atob('<?php echo $_GET["id"]; ?>');

  $.ajax({
    url: 'apis/fetch_course_details.php',
    method: 'GET',
    data: { course_id: courseId },
    dataType: 'json',
    success: function (response) {
      if (response.status === 'success') {
        const course = response.data;
        
        $('#startResumeBtn').text(course.button_name || 'Start Course');

        // Set Course Title and Description
        $('#course_title').text(course.course_title);
        $('#course_description').text(course.course_description);

        const imgHtml = `
          <img
            src="${course.course_img}"
            alt="${course.course_title}"
            class="img-fluid mb-3 course-img"
            style="width: 100%; max-height: fit-content; object-fit: cover; height: 315px; border-radius: 20px; margin-top: 20px;"
          />
        `;
        document.getElementById('imageContainer').innerHTML = imgHtml;

        // Populate Skills
        const skills = course.skills.split(',');
        $('#skillsContainer').empty();
        skills.forEach(skill => {
          $('#skillsContainer').append(
            `<span class="skills-badge">${skill.trim()}</span>`
          );
        });

        let learningsArray = [];
        learningsArray = JSON.parse(course.learnings);

        $('.info-grid').empty();
        learningsArray.forEach(item => {
          $('.info-grid').append(`<div class="info-item">${item}</div>`);
        });

        const mentorNames = course.mentors.map(m => `${m.mentor_name}`).join(', ');
        $('.box-title-mentor').html(`<strong>Mentor:</strong> ${mentorNames}`);

        const expertNames = course.industry_experts.map(m => `${m.mentor_name}`).join(', ');
        $('.box-title-expert').html(`<strong>Industry Expert:</strong> ${expertNames}`);

        // Populate Modules
        const moduleCard = $('.module-card');
        moduleCard.empty();

        // Add course title and author to module section
        moduleCard.append(`<div class="course-title text-color">${course.course_title}</div>`);
        moduleCard.append(`<br>`); // You can replace with dynamic author if needed

        // Loop and append each module
        course.modules.forEach((mod, index) => {
          const icon = mod.description ? '📄' : '⏺';
          const moduleHtml = `
            <div class="module">
              <div class="module-title"><i>${icon}</i> Module ${index + 1} - ${mod.module_name}</div>
              ${mod.description ? `<div class="module-desc">${mod.description}</div>` : ''}
            </div>
          `;
          moduleCard.append(moduleHtml);
        });

        // Populate course hours
        const hours = course.hours || "Not specified";  // Default in case hours are not available
        $('#course-hours').text(hours);

        // Populate course level with first letter capitalized
        let levelText = "";
        let levelDescription = "";

        if(course.level === "1") {
          levelText = "Beginner level";
          levelDescription = "No prior experience required";
        } else if(course.level === "2") {
          levelText = "Intermediate level";
          levelDescription = "Experience required";
        } else if(course.level === "3") {
          levelText = "Advanced level";
          levelDescription = "Full experience required";
        } else {
          levelText = "Level not specified";
          levelDescription = "Level information not available";
        }

        // Capitalize first letter of level text
        levelText = levelText.charAt(0).toUpperCase() + levelText.slice(1);
        $('#course-level').text(levelText);
        $('#level-description').text(levelDescription);

        // Set language text and capitalize the first letter of language
        const languageText = course.language ? course.language.charAt(0).toUpperCase() + course.language.slice(1) : "Language not specified";
        $('#course-language').text(languageText); // Dynamically populate language

        // Populate File, Video, and Module counts in "AT GLANCE" section
        $('#moduleCount').text(`${course.module_count} Modules`);
        $('#mediaCount').html(`${course.video_count} videos<br>${course.file_count} Documents`);
        

	// Populate FAQ container
	$('#faqAccordion').empty();
	
	const faqs = course.faqs || [];
	
	if (faqs.length === 0) {
	  $('#faqAccordion').html('<p class="text-muted">No FAQs available.</p>');
	} else {
	  faqs.forEach((faq, index) => {
	    const faqHtml = `
	      <div class="accordion-item">
	        <h2 class="accordion-header" id="heading${index}">
	          <div class="faq-question collapsed"
	               data-toggle="collapse"
	               data-target="#collapse${index}"
	               aria-expanded="false"
	               aria-controls="collapse${index}">
	            <span>Q${index + 1}: ${faq.faq_question}</span>
	            <i class="fa fa-chevron-down faq-arrow" style="margin-left: 5px;"></i>
	          </div>
	        </h2>
	
	        <div id="collapse${index}"
	             class="collapse"
	             aria-labelledby="heading${index}"
	             data-parent="#faqAccordion">
	          <div class="accordion-body">
	            ${faq.faq_answer}
	          </div>
	        </div>
	      </div>
	    `;
	    $('#faqAccordion').append(faqHtml);
	  });
	}




      } else {
        alert(response.message);
      }
    },
    error: function () {
      alert('Error fetching course data.');
    }
  });
});



$(function () {
  $('#courseInfoBtn, #modulesBtn').on('click', function () {
    const isCourseInfo = this.id === 'courseInfoBtn';

    $('#courseInfoSection').toggle(isCourseInfo);
    $('#modulesSection').toggle(!isCourseInfo);

    $('#courseInfoBtn').toggleClass('active', isCourseInfo).toggleClass('inactive', !isCourseInfo);
    $('#modulesBtn').toggleClass('active', !isCourseInfo).toggleClass('inactive', isCourseInfo);
  });
});
</script>
</body>
</html>