<?php 
$page_name = 'Masters';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>

.skin-blue .main-header .navbar {
    background-color: #fff;
}

.login-profile {
    height: 90px;
}

.content-wrapper, .main-footer {
  margin-left: unset !important;
}

.main-header .navbar {
  margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
  border-bottom: 1px solid #5C2C8B;
}

.progress-bar {
  background-color: #5C2C8B;
}

.module-list {
  list-style: none;
  padding: 0;
  margin-top: 15px;
}

.module-list li {
  padding: 5px 15px;
  border-radius: 5px;
  margin-bottom: 15px;
  background-color: #fff;
  cursor: pointer;
  border: 1px solid #ddd;
  transition: all 0.3s ease;
  color: #333;
}

.module-list li:hover {
  background-color: #f2e8fc;
  color: #5C2C8B;
}

.module-list li.active {
  background-color: #E9DFF8;
  color: #5C2C8B;
  font-weight: 600;
  border-left: 5px solid #5C2C8B;
}

.btn-dark {
  background-color: #5C2C8B;
  border-color: #5C2C8B;
}

.course-box {
  padding: 30px 0px;
}



#moduleTitle {
  color: #5C2C8B;
  font-size: 22px;
  font-weight: bold;
}

iframe {
  border-radius: 8px;
}

.quiz-box {
  padding: 30px;
  background-color: #f3ecff;
  border: 2px dashed #5C2C8B;
  border-radius: 10px;
  text-align: center;
  font-size: 18px;
  color: #5C2C8B;
  font-weight: bold;
}

@media (max-width: 767px) {
  .col-md-4, .col-md-8 {
    padding: 10px;
  }
}

.video-container {
  position: relative;
  padding-bottom: 56.25%; /* 16:9 ratio */
  height: 0;
  overflow: hidden;
  margin-bottom: 20px;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.video-container iframe {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border: none;
}


.timeline-toggle {
  margin-bottom: 20px;
  border-radius: 50px !important;
}

.timeline-wrapper {
      border-left: 2px dashed #6A1B9A;
  padding-left: 20px;
  margin-left: 15px;
  max-width: 300px;
}

.timeline-item {
  display: flex;
  align-items: flex-start;
}


.timeline-icon {
  font-size: 20px;
  margin-right: 10px;
  color: #6a1b9a;
}

.timeline-content h4 {
  margin: 0;
  color: #6a1b9a;
  font-size: 16px;
}

.timeline-content p {
  margin: 3px 0 0;
  font-size: 14px;
}

.assignment p {
  font-weight: bold;
}

.assignment.completed p {
  color: #4caf50;
}

.assignment.due-soon p {
  color: #ff5722;
}

.assignment.upcoming p {
  color: #ff9800;
}


.progress {
    height: 5px;
}

.btn-right {
    float: right;
}


.timeline-container {
  display: flex;
  flex-direction: column;
  max-width: 250px;
}



.icon-wrapper {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-right: 10px;
  position: relative;
  width: 24px;
}

.icon {
  width: 20px;
  height: 20px;
  z-index: 2;
}

.line {
  width: 2px;
  height: 50px;
  border-left: 2px dashed #a259cf;
  margin-top: 2px;
  z-index: 1;
}

.content .label {
  font-weight: bold;
  color: #6a1b9a;
  font-size: 16px;
  padding: unset;
}

.content .date {
  font-size: 14px;
  color: #6a1b9a;
}

.content {
    background: #F7F5F9 !important;
        padding: 0px 20px !important;
}

.course-title
{
        color: #5B2E8E;
    line-height: 30px;
    font-size: 20px;
}

@media (min-width: 768px) {
    .navbar-nav > li > a {
        padding-top: 30px;
    }
}

</style>

<div class="content-wrapper">
  <section class="content">
    <div class="row">
      <div class="col-md-3">
          <div class="course-box">
    <h4 class="course-title" id="courseTitle"><strong></strong></h4>
    <p id="mentorNames1"></p> <!-- To display mentor names -->
    <br>

        <div class="progress">
          <div class="progress-bar" style="width: 0%"></div>
        </div>
        <div><span id="progressText">0%</span> Completed</div>
        <br>
        
        <ul class="module-list mt-3" id="moduleList">
          <!-- Modules will be inserted dynamically -->
        </ul>

<button type="button" onclick="toggleTimeline()" class="btn btn-block btn-primary btn-flat timeline-toggle" style="margin-top: 50px;    letter-spacing: 1px;
    height: 40px;"><b>COURSE TIMELINE</b></button>



<div class="timeline-container" id="courseTimeline" style="display: none; padding-left: 20px;">
  <!-- Content added by JavaScript -->
</div>


      </div>
      </div>

      <div class="col-md-9">
        <div class="course-box">
          <h4 id="moduleTitle">Course Content</h4>
          <p id="mentorNames2"></p>

          <div id="moduleContent" class="mt-4">
            <!-- Dynamic Content Goes Here -->
          </div>

    <div class="btn-right mt-4" style="    margin: 25px 0px;">
      <button type="button" id="prevBtn" class="btn btn-secondary" onclick="prevContent()">< Previous</button>
      <button type="button" class="btn btn-primary btn-right-mrg" onclick="nextContent()">Next ></button>
    </div>

        </div>
      </div>
    </div>
  </section>
</div>




<?php require_once('includes/footer.php'); ?>

<script>
const courseId = atob('<?php echo $_GET["id"]; ?>');
let modules = [];
let flatContent = [];
let currentIndex = 0;
let maxCompletedIndex = -1; // -1 means no progress yet

function fetchProgress(callback) {
  $.ajax({
    url: 'apis/get_course_progress.php',
    method: 'GET',
    data: { course_id: courseId },
    xhrFields: { withCredentials: true },
    success: ({ status, data }) => {
      if (status === "success") {
        if (data === "NOTSTARTED") {
          currentIndex = 0;
          maxCompletedIndex = -1;
        } else if (data && typeof data === "object") {
          currentIndex = parseInt(data.last_content_index) || 0;
          maxCompletedIndex = parseInt(data.max_completed_index);
          if (isNaN(maxCompletedIndex) || maxCompletedIndex < 0) maxCompletedIndex = -1;
        }
      } else {
        currentIndex = 0;
        maxCompletedIndex = -1;
      }
      callback();
    },
    error: () => {
      currentIndex = 0;
      maxCompletedIndex = -1;
      callback();
    }
  });
}

function saveProgress() {
  $.ajax({
    url: 'apis/add_course_progress.php',
    method: 'POST',
    data: { course_id: courseId, last_content_index: currentIndex, max_completed_index: maxCompletedIndex },
  });
}

function fetchCourseContent() {
  $.ajax({
    url: 'apis/fetch_course_content.php',
    method: 'GET',
    data: { id: courseId },
    success: data => {
      modules = data || [];
      flattenModules();
      buildSidebar();
      renderContent();
    },
    error: () => {
      $('#moduleContent').html("<p style='color:red;'>Failed to load course materials.</p>");
    }
  });
}


function fetchCourseDetails() {
  $.ajax({
    url: 'apis/get_course_details.php',
    method: 'GET',
    data: { id: courseId },
    success: (data) => {
      if (data.course_details) {
         const { course_title, mentor_names, start_date, end_date } = data.course_details;

        $('#courseTitle').text(course_title);

        $('#mentorNames1').html("- By " + mentor_names);

        $('#mentorNames2').html("- Mentored by " + mentor_names);
        
        updateTimeline(start_date, end_date);

      } else {
        console.error("Course details not found");
      }
    },
    error: () => {
      console.error("Failed to fetch course details.");
    }
  });
}








function flattenModules() {
  flatContent = modules.flatMap((mod, modIndex) =>
    mod.submodules.flatMap(submod =>
      submod.contents.map(item => ({
        ...item,
        moduleIndex: modIndex,
        moduleTitle: mod.title
      }))
    )
  );
}

function buildSidebar() {
  const ul = $('#moduleList').empty();
  modules.forEach((mod, i) => {
    const li = $('<li>').text(mod.title);
    const idx = flatContent.findIndex(fc => fc.moduleIndex === i);

    if (idx <= maxCompletedIndex + 1) {
      li.css({ cursor: 'pointer', opacity: 1 }).on('click', () => {
        if (idx <= maxCompletedIndex + 1) {
          currentIndex = idx;
          renderContent();
          saveProgress();
        }
      });
    } else {
      li.css({ opacity: 0.6, cursor: 'not-allowed' }).attr('title', 'Please complete previous modules first');
    }
    ul.append(li);
  });
  updateSidebarHighlight();
}

function updateSidebarHighlight() {
  if (!flatContent.length) return;
  const activeModuleIndex = flatContent[currentIndex]?.moduleIndex;
  $('#moduleList li').each((i, el) => {
    $(el).toggleClass('active', i === activeModuleIndex);
  });
}

function renderContent() {
  if (!flatContent.length) return;
  const item = flatContent[currentIndex];
  $('#moduleTitle').text(item.title || item.moduleTitle);

  let html = '';
  switch(item.type) {
    case 'video':
      html = `<div class="video-container"><iframe src="${item.src}" allowfullscreen></iframe></div>`;
      break;
case 'pdf':
  html = `
    <div style="position: relative; width: 100%; height: 600px; border-radius: 8px; overflow: hidden;">
      
      <iframe 
        src="${item.src}#toolbar=0&navpanes=0&scrollbar=0" 
        style="width: 100%; height: 100%; border: none;" 
        id="pdfIframe"
        oncontextmenu="return false;"
      ></iframe>
      
      <div 
        style="
          position: absolute;
          top: 0;
          left: 0;
          width: calc(100% - 15px);
          height: 100%;
          z-index: 10;
          background: transparent;
        "
        oncontextmenu="return false;"
        onmousedown="return false;"
        onselectstart="return false;"
        title="Right-click is disabled"
      ></div>
    </div>
  `;
  break;
  
case 'ppt':
case 'pptx':
  html = `
    <div style="position: relative; width: 100%; height: 600px; border-radius: 8px; overflow: hidden;">
      <iframe 
        src="https://view.officeapps.live.com/op/embed.aspx?src=https://kapps.co.in/EPIC_LMS/${item.src}" 
        style="width: 100%; height: 100%; border: none;" 
        oncontextmenu="return false;">
      </iframe>
    </div>
      <div 
        style="
          position: absolute;
          top: 0;
          left: 0;
          width: calc(100% - 15px);
          height: calc(100% - 105px);
          z-index: 10;
          background: transparent;
        "
        oncontextmenu="return false;"
        onmousedown="return false;"
        onselectstart="return false;"
        title="Right-click is disabled"
      ></div>
    </div>  
  `;
  break;  

    case 'text':
      html = `<div style="background:white;color:black;padding:20px;border-radius:8px;">${item.content}</div>`;
      break;
    case 'quiz':
      const quizLink = item.link || `quiz.php?quiz_id=${item.quiz_id}`;
      html = `<div class="quiz-box"><a href="${quizLink}" class="btn btn-primary mt-3">Start Quiz</a></div>`;
      break;
    default:
      html = `<p>Unknown content type.</p>`;
  }

  $('#moduleContent').html(html);

  const completedCount = maxCompletedIndex >= 0 ? maxCompletedIndex + 1 : 0;
  const percent = flatContent.length > 0 ? Math.round((completedCount / flatContent.length) * 100) : 0;

  $('.progress-bar').css('width', percent + '%');
  $('#progressText').text(`${percent}%`);

  updateSidebarHighlight();
  window.scrollTo({ top: 0, behavior: 'smooth' });
  
if (currentIndex === 0) {
  $('#prevBtn').hide();
} else {
  $('#prevBtn').show();
}
  
}

function nextContent() {
  if (currentIndex < flatContent.length - 1) {
    currentIndex++;
    if (currentIndex > maxCompletedIndex) maxCompletedIndex = currentIndex - 1;
    renderContent();
    saveProgress();
    buildSidebar();
  } else {
    if (currentIndex > maxCompletedIndex) {
      maxCompletedIndex = currentIndex;
      saveProgress();
    }
    alert("🎉 Congratulations! You’ve completed the course.");
    window.location.href = "courses.php";
  }
}

function prevContent() {
  if (currentIndex > 0) {
    currentIndex--;
    renderContent();
    saveProgress();
    buildSidebar();
  }
}


function updateTimeline(startDate, endDate) {
  const formattedStart = formatDate(startDate);
  const formattedEnd = formatDate(endDate);

  const timelineHTML = `
    <div class="timeline-item">
      <div class="icon-wrapper">
        <img src="icons/feather-map-pin.svg" alt="Start Icon" class="icon" />
        <div class="line"></div>
      </div>
      <div class="content1">
        <div class="label">Start Date</div>
        <div class="date">${formattedStart}</div>
      </div>
    </div>

    <div class="timeline-item">
      <div class="icon-wrapper">
        <img src="icons/feather-award.svg" alt="End Icon" class="icon" />
      </div>
      <div class="content1">
        <div class="label">End Date</div>
        <div class="date">${formattedEnd}</div>
      </div>
    </div>

    <br>
    <div class="content1">
      <div class="label" style="font-size: 13px;">You have completed the course on ${formattedEnd}</div>
    </div>
  `;

  $('#courseTimeline').html(timelineHTML);
}


function formatDate(dateStr) {
  const date = new Date(dateStr);
  const day = date.getDate();
  const suffix = getOrdinalSuffix(day);
  const month = date.toLocaleString('default', { month: 'short' });
  const year = date.getFullYear();
  return `${day}${suffix} ${month} ${year}`;
}

function getOrdinalSuffix(day) {
  if (day > 3 && day < 21) return 'th';
  switch (day % 10) {
    case 1: return 'st';
    case 2: return 'nd';
    case 3: return 'rd';
    default: return 'th';
  }
}

function toggleTimeline() {
  $('#courseTimeline').toggle();
}

$(document).ready(() => fetchProgress(fetchCourseContent));

$(document).ready(() => {
  fetchCourseDetails();
});

$(document).on('contextmenu', e => e.preventDefault());


</script>





</body>
</html>