<?php
session_start();

require_once('connection.php');

$currentPage = basename($_SERVER['PHP_SELF']);

$page_class = isset($page_name) ? strtolower(str_replace(' ', '-', $page_name)) : '';


if (isset($_SESSION['category']) && $_SESSION['category'] != 'superadmin' && 
    ($currentPage == 'add_institute.php' || $currentPage == 'edit_institute.php' || $currentPage == 'institute_master.php')) {
    header("Location: access_denied.php");
    exit();
}

if (isset($_SESSION['category']) && ($_SESSION['category'] == 'superadmin' || $_SESSION['category'] == 'institute')) {
    header("Location: access_denied.php");
    exit();
}

if (empty($_SESSION['category']) || empty($_SESSION['user_id']) || empty($_SESSION['email_id'])) {
    header("Location: logout.php");
    exit();
}

$category = $_SESSION['category'];
$user_id = $_SESSION['user_id'];
$email_id = $_SESSION['email_id'];
$institute_id = $_SESSION['institute_id'];
$user_name = $_SESSION['user_name'];

//Institute Image Fetch
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }
    
    $sqlCourses = "SELECT institute_img FROM institute_master WHERE institute_id = :institute_id";

    $stmtCourses = $pdo->prepare($sqlCourses);
    $stmtCourses->execute([':institute_id' => $institute_id]);
    $courses = $stmtCourses->fetchAll(PDO::FETCH_ASSOC);

    // Add full image path based on whether course is superadmin or not
    foreach ($courses as &$course) {
        $imageName = $course['institute_img'];
    }
$institute_img = "Z1mn7_adm/institutes/{$currentFolder}/institute_images/{$imageName}";
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="shortcut icon" href="images/favicon.svg" type="image/x-icon">
    <link rel="icon" href="images/favicon.svg" type="image/x-icon">

    <title><?php echo $page_name; ?></title>

	<link rel="stylesheet" href="assets/bootstrap/css/bootstrap.css">

	<link rel="stylesheet" href="assets/font-awesome/css/font-awesome.css">

	<link rel="stylesheet" href="assets/ionicons/css/ionicons.css">

	<link rel="stylesheet" href="css/master_style.css">

	<link rel="stylesheet" href="css/_all-skins.css">
	
	<link rel="stylesheet" href="css/custom.css">
	
	<link rel="stylesheet" href="assets/select2/dist/js/select2.min.css">
	
	<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
	
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  </head>
  
  <body class="hold-transition skin-blue sidebar-mini <?= $page_class ?>">
    <div class="wrapper">

  <header class="main-header">

    <nav class="navbar navbar-static-top">
<a href="#" class="sidebar-toggle">
   <img src="images/logo-dark.svg" id="sidebar-toggle-icon" style="height: 50px;" />
</a>

<a href="#" class="sidebar-toggle" style="margin: -13px;">
   <img src="<?php echo $institute_img; ?>" id="sidebar-toggle-icon" style="height: 75px;" />
</a>

      <div class="navbar-custom-menu" style="margin-right: 25px;">
        <ul class="nav navbar-nav">

<a href="courses.php" style="color: #3b1e84; font-size: 18px;"><li class="" style="padding: 8px 0px 0px 0px;"> <i class="fa fa-home"></i></a>
<li class="dropdown messages-menu" style="padding: 20px 4px 2px 15px;">
            <a href="#" class="dropdown-toggle" style="    background: #5B2E8E;
    padding: 6px 13px;
    border-radius: 6px;" data-toggle="dropdown" aria-expanded="true">
            <i class="fa fa-user" style="font-size: 15px;
    margin-right: 5px;
    color: #fff;"></i>                
              <?php echo $user_name; ?>
            </a>
            <ul class="dropdown-menu scale-up">
              <li>
                <!-- inner menu: contains the actual data -->
                <div class="slimScrollDiv"><ul class="menu inner-content-div">
                  <li><!-- start message -->
                    <a href="#">
                      <div class="mail-contnet">
                         <h4>
                          <i class="fa fa-user" style="margin-right:10px;"></i><?php echo $user_name; ?>
                          <br><?php echo $email_id; ?>
                         </h4>
                      </div>
                    </a>
                  </li>                    
                  <li><!-- start message -->
                    <a href="dashboard.php">
                      <div class="mail-contnet">
                         <h4 style="padding-left: 20%;">
                          <i class="fa fa-th-large" style="margin-right:10px;"></i>Dashboard
                         </h4>
                      </div>
                    </a>
                  </li>
                  <!-- end message -->
                  <li><!-- start message -->
                    <a href="courses.php">
                      <div class="mail-contnet">
                         <h4 style="padding-left: 20%;">
                          <i class="fa fa-tv (alias)" style="margin-right:10px;"></i>Courses
                         </h4>
                      </div>
                    </a>
                  </li>
                  <li><!-- start message -->
                    <a href="all_certificates.php">
                      <div class="mail-contnet">
                         <h4 style="padding-left: 20%;">
                          <i class="fa fa-certificate" style="margin-right:10px;"></i>Certificate
                         </h4>
                      </div>
                    </a>
                  </li>
                  <li><!-- start message -->
                    <a href="#">
                      <div class="mail-contnet">
                         <h4 style="padding-left: 20%;">
                          <i class="fa fa-bell-o" style="margin-right:10px;"></i>Notification
                         </h4>
                      </div>
                    </a>
                  </li>
                 <li>
                    <a href="change_password.php">
                      <div class="mail-contnet">
                         <h4  style="padding-left: 20%;">
                          <i class="fa  fa-key" style="margin-right:10px;"></i>Reset Password
                         </h4>
                      </div>
                    </a>
                  </li> 
                 <li>
                    <a href="student_enquiry.php">
                      <div class="mail-contnet">
                         <h4  style="padding-left: 20%;">
                          <i class="fa  fa-ticket" style="margin-right:10px;"></i>Get Help
                         </h4>
                      </div>
                    </a>
                  </li>                  
                 <li>
                    <a href="logout.php">
                      <div class="mail-contnet">
                         <h4  style="padding-left: 20%;">
                          <i class="fa fa-sign-out" style="margin-right:10px;"></i>Logout
                         </h4>
                      </div>
                    </a>
                  </li>                  
                </ul>
              </li>
            </ul>
          </li>
  
          
        </ul>
      </div>
    </nav>
  </header>