// course_helpers.js

function populateAllDropdowns(apiUrl) {
    $.ajax({
        url: apiUrl,
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            
            // Populate Modules
            
            if (Array.isArray(data.modules)) {
                $('#module').empty().append('<option value="">Select Module</option>');
                data.modules.forEach(function (item) {
                    $('#module').append(`<option value="${item.id}">${item.name}</option>`);
                });
            }


            // Populate Sub Modules
            if (Array.isArray(data.sub_modules)) {
                $('#sub_module').empty().append('<option value="">Select Sub Module</option>');
                data.sub_modules.forEach(function (item) {
                    $('#sub_module').append(`<option value="${item.id}">${item.name}</option>`);
                });
            }

            // Populate Course Materials
            if (Array.isArray(data.course_materials)) {
                $('#course_material').empty().append('<option value="">Select Course Material</option>');
                data.course_materials.forEach(function (item) {
                    $('#course_material').append(`<option value="${item.id}">${item.name}</option>`);
                });
            }
            
            // Populate Category
            if (Array.isArray(data.category)) {
                $('#category').empty().append('<option value="">Select Category</option>');
                data.category.forEach(function (item) {
                    $('#category').append(`<option value="${item.id}">${item.name}</option>`);
                });
            }
            
            // Populate Course
            if (Array.isArray(data.courses)) {
                $('#course').empty().append('<option value="">Select Course</option>');
                data.courses.forEach(function (item) {
                    $('#course').append(`<option value="${item.id}">${item.name}</option>`);
                });
            }
            
            // Populate Testimonials
            if (Array.isArray(data.testimonials)) {
                $('#testimonial').empty();
                data.testimonials.forEach(function (item) {
                    $('#testimonial').append(`<option value="${item.id}">${item.name}</option>`);
                });
                $('#testimonial').trigger('change');
            }
            
            // Populate mentor
            if (Array.isArray(data.mentors)) {
                $('#mentor').empty();
                data.mentors.forEach(function (item) {
                    $('#mentor').append(`<option value="${item.id}">${item.name}</option>`);
                });
                $('#mentor').trigger('change');
            }
            // Populate Proposed Courses
            if (Array.isArray(data.proposed_courses)) {
                $('#proposed_course').empty(); 
                data.proposed_courses.forEach(function (item) {
                    $('#proposed_course').append(`<option value="${item.id}">${item.name}</option>`);
                });
                $('#proposed_course').trigger('change');
            }

        },
        error: function (xhr, status, error) {
            console.error('Failed to load dropdown data:', error);
        }
    });
}
