<?php 
require_once('includes/login_header.php');
?>
<style>

@media only screen and (min-width: 769px) {
    .login-box {
        width: 30% !important;
    }
}
</style>
<body>
    <div class="login-box">
        <div class="login-box-body">
            <div class="row">
                <div class="col-md-12">
                    <p class="pl-15 mb-15 text-color">An email will be sent to your registered email ID.</p>

                    <form id="resetPasswordForm" class="login-form">
                        <div class="error-message text-danger text-center"></div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="text-color">New Password</label>
                                <input class="form-control login-textbox" type="text" autocomplete="off" id="new_password" name="new_password" required>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="text-color">Confirm New Password</label>
                                <input class="form-control login-textbox" type="password" autocomplete="off" id="confirm_password" name="confirm_password" required>
                            </div>
                        </div>
                     


                        <div class="col-md-12" style="margin-bottom:20px;">
                            <button type="submit" class="btn btn-primary form-control" id="sendBtn">Reset</button>
                        </div>            
                        <div class="success-message text-danger text-center"></div>
                    </form>


                </div>

                
            </div>
        </div>
    </div>

<?php require_once('includes/login_footer.php'); ?>

<script>

        function getUrlParameter(name) {
            name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
            var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
            var results = regex.exec(location.search);
            return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
        }
        
$('#resetPasswordForm').on('submit', function (e) {
    e.preventDefault();

    var new_password = $('#new_password').val();
    var confirm_password = $('#confirm_password').val();
    var token = getUrlParameter('token');

    if (new_password !== confirm_password) {
        $('.success-message')
            .removeClass('text-success')
            .addClass('text-danger')
            .text('Passwords do not match.');
        return;
    }

    $.ajax({
        url: 'apis/reset_password.php',
        method: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ 
            new_password: new_password,
            token: token 
        }),
        success: function(response) {
    if (response.status) {
        $('.success-message')
            .removeClass('text-danger')
            .addClass('text-success')
            .text(response.message);

        // Clear form fields
        $('#new_password').val('');
        $('#confirm_password').val('');

        // Redirect after short delay (e.g. 2 seconds)
        setTimeout(function() {
            window.location.href = 'https://epicbiospheres.com/LMS/index.php';
        }, 2000);
    } else {
                $('.success-message')
                    .removeClass('text-success')
                    .addClass('text-danger')
                    .text(response.message);
            }
        },
        error: function() {
            $('.success-message')
                .removeClass('text-success')
                .addClass('text-danger')
                .text('An error occurred. Please try again.');
        }
    });
});

</script>


</body>
</html>