<?php 
$page_name = 'Courses';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>
.content-wrapper, .main-footer {
    margin-left: unset !important;
}
.main-header .navbar {
    margin-left: unset !important;    
}
.skin-blue .main-header .navbar {
    border-bottom: 1px solid #5C2C8B;
}

.form-success {
    color: #065f46;
    font-weight: 500;
}

.form-error {
    color: #991b1b;
    font-weight: 500;
}

.content {
  padding: 20px 50px;
}
</style>


<section class="content">
    
            <form id="studentForm" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="col-md-12">

                        <div class="form-group clearfix">
                            <label for="username" class="col-md-2 col-form-label text-color"><b>Get Help</b></label>
                        </div>
                        
                        <div class="form-group clearfix">
                            <label for="studentname" class="col-md-2 col-form-label">Student Name</label>
                            <div class="col-md-4">
                                <input class="form-control" type="text" value="<?php echo $user_name; ?>" id="studentname" name="studentname" readonly>
                            </div>
                        </div>
                        
                        <input type="hidden" name="course_name" id="course_name">


                        <div class="form-group clearfix">
                            <label for="course" class="col-md-2 col-form-label">Course Program</label>
                            <div class="col-md-4">
                                <select class="form-control select2" id="course" name="course" style="width: 100%;" required>
                                </select>
                            </div>
                        </div>
                      

                        <div class="form-group clearfix">
                            <label for="category" class="col-md-2 col-form-label">Category</label>
                            <div class="col-md-4">
                                <select class="form-control select2" id="category" name="category" style="width: 100%;" required>
                                    <option value="">Select Category</option>
                                    <option value="Technical Issues">Technical Issues</option>
                                    <option value="Course or Content-Related Queries">Course or Content-Related Queries</option>
                                    <option value="Certificate or Login-Related Issues">Certificate or Login-Related Issues</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="form-group clearfix">
                            <label for="email_address" class="col-md-2 col-form-label">Issue Title</label>
                            <div class="col-md-4">
                                <input class="form-control" type="text" id="title" name="title" required>
                            </div>
                        </div>
                        
                        <div class="form-group clearfix">
                            <label for="description" class="col-md-2 col-form-label">Issue Description</label>
                            <div class="col-md-4">
<textarea class="form-control" id="description" name="description" rows="3" required=""></textarea>
                            </div>
                        </div>
                        
                        <div class="form-group clearfix">
                            <label for="attachment" class="col-md-2 col-form-label">Upload Attachment</label>
                            <div class="col-md-4">
<input class="form-control" type="file" id="attachment" name="attachment" accept=".pdf,.ppt,.pptx,.png,.jpg,.jpeg,.mp4,.txt">
                            </div>
                        </div>                                                
                        

                        <div class="box-footer mt-4" style="margin-top: 30px;">
                            <button type="submit" class="btn btn-primary" id="btnText">Send</button>
                        </div>
                        
<div class="box-footer mt-2">
    <div id="formMessage" style="display:none;"></div>
</div>
                        
                    </div>
                </div>
            </form> 

</section>

<?php require_once('includes/footer.php'); ?>

<script>
function populateCourses(selectorId) {
    $.ajax({
        url: 'apis/fetch_course_dropdown.php',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            if (data.status === 'success' && Array.isArray(data.courses)) {
                let options = '<option value="">Select Course</option>';
                data.courses.forEach(function (course) {
                    options += `<option value="${course.id}">${course.name}</option>`;
                });

                const $select = $('#' + selectorId);
                $select.html(options);
                $select.select2();
            }
        }
    });
}
populateCourses('course');



function showMessage(type, message) {
    const msgBox = $("#formMessage");

    msgBox
        .removeClass("form-success form-error")
        .addClass(type === "success" ? "form-success" : "form-error")
        .html(message)
        .fadeIn();

    setTimeout(() => {
        msgBox.fadeOut();
    }, 5000);
}

$("#studentForm").on("submit", function (e) {
    e.preventDefault();
    
    const courseName = $("#course option:selected").text();
    $("#course_name").val(courseName);

    let attachment = $("#attachment")[0].files[0];
    if (attachment && attachment.size > 1 * 1024 * 1024) {
        alert("Attachment exceeds 1MB size limit.");
        return;
    }
    
    let btn = $("#btnText");
    btn.prop("disabled", true).text("Sending...");

    let formData = new FormData(this);

    $.ajax({
        url: "apis/student_enquiry_mail.php",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "json",

        success: function (res) {
            if (res.status === "success") {
                showMessage(
                    "success",
                    res.message || "Your enquiry has been submitted successfully."
                );
                // Reset normal inputs
		$("#studentForm")[0].reset();
		$("#course").val("").trigger("change");
		$("#category").val("").trigger("change");

            } else {
                showMessage(
                    "error",
                    res.message || "Something went wrong. Please try again."
                );
            }
        },

        error: function () {
            showMessage(
                "error",
                "Server error. Please try again later."
            );
        },

        complete: function () {
            btn.prop("disabled", false).text("Send");
        }
    });
});
</script>



</body>
</html>