<?php 
session_start();

if (!isset($_SESSION['email_id'])) {
    header("Location: access_denied.php");
    exit();
}

require_once('includes/login_header.php');
require_once('includes/PHPMailerAutoload.php');
require_once('includes/class.phpmailer.php');
require_once('includes/class.smtp.php');

// Handle resend OTP via AJAX
if (isset($_GET['resend']) && $_GET['resend'] === 'true') {
    echo json_encode(sendOtp($_SESSION['email_id']));
    exit;
}

// First time page load or redirect here after login
$otp_result = sendOtp($_SESSION['email_id']);
$success_message = $otp_result['message'];

// Function to generate and send OTP
function sendOtp($email) {
    //$otp = rand(100000, 999999);

    $otp = 1234;    
    $_SESSION['otp'] = $otp;
    
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.zoho.in';
        $mail->SMTPAuth   = true;
        $mail->Username = 'notifications@epicbiospheres.com';
        $mail->Password = '8FLKDuJhzxZ1';
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;
        $mail->From = 'notifications@epicbiospheres.com';
        $mail->FromName = 'EPIC LMS';
        $mail->addAddress($_SESSION['email_id']);

        $mail->isHTML(true);
        $mail->Subject = 'Your One-Time Password (OTP) for Login';
$mail->Body = <<<EOD
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <style>
    body {
      margin: 0;
      padding: 0;
      background-color: #f6f6f6;
      font-family: Poppins, sans-serif;
      color: #333;
    }
    
  .email-container {
    max-width: 600px;
    margin: 40px auto;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    width: 99%;
  }
    .email-header {
      background: linear-gradient(135deg, #5C2C8B, #7C43BD);
      padding: 30px;
      text-align: center;
      color: #ffffff;
    }
    .email-header img {
      max-height: 60px;
      margin-bottom: 15px;
    }
    .email-header h1 {
      margin: 0;
      font-size: 26px;
      font-weight: 600;
    }
    .email-body {
      padding: 30px;
    }
    .email-body h2 {
      font-size: 22px;
      color: #5C2C8B;
      margin-top: 0;
    }
    .email-body p {
      line-height: 1.6;
      margin-bottom: 20px;
    }
    .credentials-box {
      background-color: #f4eeff;
      border-left: 6px solid #5C2C8B;
      padding: 20px;
      margin: 20px 0;
      border-radius: 6px;
      font-size: 16px;
    }
    .credentials-box strong {
      color: #333;
    }
    .login-button {
      display: inline-block;
      background-color: #5C2C8B;
      color: #fff !important;
      padding: 12px 24px;
      border-radius: 6px;
      text-decoration: none;
      font-weight: bold;
      margin-top: 10px;
      transition: background 0.3s ease;
    }
    .login-button:hover {
      background-color: #45216a;
    }
    .email-footer {
      background-color: #fafafa;
      padding: 15px;
      text-align: center;
      font-size: 12px;
      color: #777;
    }
    .otp-text
    {
    text-align: center;
    font-size: 45px;
    letter-spacing: 10px;
    }
  </style>
</head>
<body>

  <div class="email-container">
    <div class="email-header">
      <img src="https://epicbiospheres.com/LMS/images/logo-email.png" alt="EPIC LMS">
      <h2>Your One-Time Password (OTP) for Login</h2>
    </div>
    <div class="email-body">
      <h2>Dear User,</h2>
      <p>We received a login request. Use the OTP below to continue:</p>

        <center><h2><strong class="otp-text">$otp</strong></h2></center>

    </div>
    <div class="email-footer">
      &copy; 2026 EPIC LMS. This is an automated message. Please do not reply.
    </div>
  </div>

</body>
</html>
EOD;
        $mail->AltBody = 'Your OTP is: ' . $otp;

        $mail->send();
        return ['status' => 'success', 'message' => 'We have sent the verification code to your email address.'];
    } catch (Exception $e) {
        return ['status' => 'error', 'message' => 'Failed to send OTP. Please try again later.'];
    }
}

?>
<style>

@media only screen and (min-width: 769px) {
    .login-box {
        width: 30% !important;
    }
}
</style>
<body>
    <div class="login-box">
        <div class="login-box-body">
            <div class="row">
                <div class="col-md-12">
                    <h3 class="pl-15 mb-20 text-color text-center">OTP Verification</h3>

                    <form id="otpForm" class="login-form">
                        <div class="error-message text-success text-center mb-10"><?php echo $success_message; ?></div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="text-color">Enter OTP</label>
                                <input class="form-control login-textbox" type="number" autocomplete="off" id="otp" name="otp" required>
                            </div>
                        </div>


                        <div class="col-md-12" style="margin-bottom:20px;">
                            <button type="submit" class="btn btn-primary form-control">Verify OTP</button>
                        </div>            
                        <div class="success-message text-danger text-center"></div>
                    </form>

                    <div class="margin-top-30 text-center">
                        <p style="color:#5C2C8B;">Didn't receive the email?
                        <a href="javascript:void(0);" id="resendLink" class="text-info m-l-5 hover-underline" onclick="handleResend(event);" style="color:#5C2C8B;">
                            Resend
                        </a>
                        <span id="timer" style="color: #999;"></span>
                    </div>

                </div>

                
            </div>
        </div>
    </div>

<?php require_once('includes/login_footer.php'); ?>

<script>
    $(document).ready(function() {
        $("#otpForm").submit(function(e) {
            e.preventDefault();

            var otp = $("#otp").val();

            $.ajax({
                url: 'apis/verify_otp_api.php',
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({ otp_input: otp }),                    
                success: function(response) {
                    if (response.status === 'success') {
                       if (response.category === 'student') {
                            window.location.href = 'courses.php';
                        }
                        else if (response.category === 'expert') {
                            window.location.href = 'Z1mn7_adm/course_master.php';
                        }
                        else {
                            window.location.href = 'Z1mn7_adm/masters.php';
                        }
                    } else {
                        $(".success-message").text(response.message);
                    }
                },
                error: function() {
                    $(".success-message").text("An error occurred. Please try again.");
                }
            });
        });
    });

    function handleResend(event) {
    event.preventDefault();

    const resendLink = document.getElementById("resendLink");
    const timer = document.getElementById("timer");
    const messageBox = document.getElementById("otp-message");

    resendLink.style.pointerEvents = "none";
    resendLink.style.color = "#aaa";

    let countdown = 60;
    timer.textContent = `(${countdown}s)`;

    const interval = setInterval(() => {
        countdown--;
        timer.textContent = `(${countdown}s)`;

        if (countdown <= 0) {
            clearInterval(interval);
            resendLink.style.pointerEvents = "auto";
            resendLink.style.color = "#5C2C8B";
            timer.textContent = "";
        }
    }, 1000);

    // AJAX call to the same PHP file
    $.ajax({
        url: window.location.href + "?resend=true",
        method: 'GET',
        success: function(response) {
            const result = JSON.parse(response);
            messageBox.textContent = result.message;
            messageBox.style.color = result.status === "success" ? "green" : "red";
        },
        error: function() {
            messageBox.textContent = "An error occurred while resending OTP.";
            messageBox.style.color = "red";
        }
    });
}


</script>


</body>
</html>